(* ::Package:: *)

(* ::Subtitle:: *)
(*Programa Computacional:*)
(*C\[AAcute]lculo de los par\[AAcute]metros del tornillo de Rodrigues *)
(*del movimiento general de un cuerpo r\[IAcute]gido*)
(*R. Pe\[OAcute]n, F. Pe\[NTilde]u\[NTilde]uri, M. Flota*)


(* ::Section:: *)
(*Puntos del cuerpo r\[IAcute]gido *)


(*Datos exp.#01*)
P1={6,5,5};
Q1={6,5,6};
R1={5,6,5};
P2={8,10,0};
Q2={8,9.6238,0.9265};
R2={7,10.9265,0.3762};

(*Datos exp.#02
P1={3,1,4};
Q1={4,0,4};
R1={4,1,3};
P2={0,2,2};
Q2={1,2,1};
R2={0,1,1};
*)


(* ::Section:: *)
(*C\[AAcute]lculo de los par\[AAcute]metros*)


TornilloRodrigues[P1_,P2_,Q1_,Q2_,R1_,R2_]:=Module[{R2Q2R1Q1,P2Q2P1Q1NEG,P2Q2P1Q1POS,TanPhi2e,eje,Phi,d,Sep,result},(
R2Q2R1Q1=(R2-Q2)-(R1-Q1);
P2Q2P1Q1NEG=(P2-Q2)-(P1-Q1);
P2Q2P1Q1POS=(P2-Q2)+(P1-Q1);
TanPhi2e=Cross[R2Q2R1Q1,P2Q2P1Q1NEG]/Dot[R2Q2R1Q1,P2Q2P1Q1POS];
eje=TanPhi2e/Norm[TanPhi2e];
Phi=2*ArcTan[Norm[TanPhi2e]];
d=Dot[eje,P2-P1];
Sep=0.5*(P1+P2+Divide[Cross[eje,P2-P1],Norm[TanPhi2e]]-Dot[eje,P1+P2]*eje);
result={Phi*180/Pi,eje,Sep,d}
)]
TornilloRodrigues[P1,P2,Q1,Q2,R1,R2]//FullSimplify


(* ::Input:: *)
(*(*P1={1,0,0};*)
(*Q11={1,1,0};*)
(*R11={2,1,-1};*)
(*P2={2,0,-1};*)
(*Q22={2,0,0};*)
(*R22={3,-1,0};*)
(**)
(*Q1=Cross[P1,Q11]*)
(*R1=Cross[Q1,P1]*)
(*Q2=Cross[P2,Q22]*)
(*R2=Cross[Q2,P2]*)
(**)*)
